local loc = _G["g_counterfeit_stealth_loc"]

if not loc or not loc.config or not loc.config.toggle then
	return
end

if not Network:is_server() then
	return
end

if not Global.level_data or not Global.level_data.level_id or Global.level_data.level_id ~= "pal" then
	return
end

local req_script = table.remove(RequiredScript:split("/"))
local event_table = {
	["assault_started"] = false,
	["pick_random_event001"] = false,
	["pick_random_event002"] = false,
	["pick_random_event003"] = false,
	["done_police_response002"] = false,
	["done_police_response001"] = false,
	["yeah_you_fucked_up002"] = false,
	["yeah_you_fucked_up001"] = false,
	["AI_in_basement_alert001"] = true,			--dont call cops from civ dead in basement?
	["disable_enemy_patrols"] = false,
	["go_loud"] = false,
	["police_suspicious"] = true,
	["police_called"] = false,
	["glass_destroyed"] = loc.config.glass,					--dont call cops from broken glass
	["civilian_called_police"] = false,
	["player_on_street"] = loc.config.player_on_street,				--outside fence
	["out_of_time"] = true,						--dont call cops when out of time
	["civi_on_street"] = false,
	["teammate_loud_shot"] = true,				--dont call cops when shooting
	["van_arrived001"] = false,
	["van_arrived002"] = false,
	["pre-choose_escape"] = true,				--stop spawn after hose
	["obj_completed010"] = true,				--dont call cops after safe explode
	["start_sewer_spawn"] = true,	--spawn sewer
	["area_chance_enemy"] = true,	--spawn sewer
	["start_setup_booby"] = true,	--disable c4
	["hose_b"] = true,				--disable shed hose
	["hose_d"] = true,				--disable fail hose
	["hose_a"] = true,				--disable garage hose
	["paper_location002"] = true,	--disable ink/paper locations
	["paper_location003"] = true,
	["paper_location004"] = true,
	["paper_location005"] = true,
	["ink_location001"] = true,
	["ink_location002"] = true,
	["ink_location004"] = true,
	["ink_location005"] = true	
	
}
local event_table_execute = {
	["start_escape_route"] = {[101326] = false, [101327] = true}		--enable manhole before/after printer started
}	
	
if string.lower(req_script) == string.lower("coremissionscriptelement") and _G["MissionScriptElement"] ~= nil then
	local orig_func_on_execute_element = MissionScriptElement.on_executed
	function MissionScriptElement:on_executed(instigator, alternative, skip_execute_on_executed)
		orig_func_on_execute_element(self, instigator, alternative, skip_execute_on_executed)
		local id = event_table_execute[self._editor_name]
		if id then
			local player = self:_check_instigator(instigator)
			if player then
				for _, v in pairs(managers.mission._scripts.default._elements) do
					if v and type(id) == "table" and id[v._id] or type(id) == "number" and v._id == id then
						v:on_executed(player)
						break
					end
				end
			end
		end
	end

	local orig_func_init = MissionScriptElement.init
	function MissionScriptElement:init(...)
		orig_func_init(self, ...)
		if event_table[self._editor_name] then
			self._values.enabled = false
		end
	end
end